/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
package cnrg.itx.ds;

import java.io.*;

/**
 * This class provides an abstraction to identify a user uniquely
 */
public class UserID implements Serializable{
	private String id = null;
	private boolean isExtension = false;
	
	/**
	 * Constructor for string
	 *    E.g. "cwn1@cornell.edu"; "gatewaysrv"
	 * @param str UserID in string format
	 */
	public UserID(String str){
		id = new String(str);
	}
	
	/**
	 * Convert to string
	 * @return a string representation of userID
	 */
	public String toString(){
		return id;
	}
}
